# Elurair GRF Normalizer

## About

Stores data in a GRF archive in a predictable way, so that two archives that contain the same _compressed_ data are binary equal in their entirety.

## Usage

rsunorm2 [-wait][-center][-splash <png image>][-progress <type>][-normalize <type>][-msg <type>] -i <file> [-i <file>] cmd [<args>...]

### `-wait`

Waits for the child process to exit before exiting. Can be useful if the parent process is also set to wait.

### `-center`

The progress window is displayed in the center of the screen instead of upper left corner.

### `-splash <png image>`

Specifies a PNG image to display as background for the progress window. The window is resize itself to the image dimensions.

### `-progress <type>`

Specifies how to present the progress UI. `type` can be one of:

0: No progress, the window is empty (default)
1: Progress bar
2: Status bar (left: progress of current archive, right: total progress)
3: 1+2

### `-normalize <type>`

Specifies how the archive is normalized. `type` can be one of:

0: Fast, requires twice the archive size of free disk space (copy+replace, default)
1: Slow, little space requirements, unsuitable for archives with many items (move in-place)

### `-msg <type>`

Specifies how to convey error messages. `type` can be one of:

0: Normal error messages (default)
1: Scary, pretends to have found cheat software

### `-i <file>`

One or more GRF archives to normalize.

### `cmd [<args>...]`

Child process to start after all GRF archives have been successfully normalized.
